/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.admin.cluster.reroute;

import java.io.IOException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.Version;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.ClusterModule;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.ClusterState;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.routing.allocation.RoutingExplanations;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.ToXContentObject;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentBuilder;

public class ClusterRerouteResponse
extends AcknowledgedResponse
implements ToXContentObject {
    private ClusterState state;
    private RoutingExplanations explanations;

    ClusterRerouteResponse() {
    }

    ClusterRerouteResponse(boolean acknowledged, ClusterState state, RoutingExplanations explanations) {
        super(acknowledged);
        this.state = state;
        this.explanations = explanations;
    }

    public ClusterState getState() {
        return this.state;
    }

    public RoutingExplanations getExplanations() {
        return this.explanations;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.state = ClusterState.readFrom(in, null);
        this.readAcknowledged(in);
        this.explanations = RoutingExplanations.readFrom(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (out.getVersion().onOrAfter(Version.V_6_3_0)) {
            this.state.writeTo(out);
        } else {
            ClusterModule.filterCustomsForPre63Clients(this.state).writeTo(out);
        }
        this.writeAcknowledged(out);
        RoutingExplanations.writeTo(this.explanations, out);
    }

    @Override
    protected void addCustomFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("state");
        this.state.toXContent(builder, params);
        builder.endObject();
        if (params.paramAsBoolean("explain", false)) {
            this.explanations.toXContent(builder, ToXContent.EMPTY_PARAMS);
        }
    }
}

