/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.admin.indices.validate.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.Query;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.ActionListener;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.admin.indices.validate.query.QueryExplanation;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.admin.indices.validate.query.ShardValidateQueryRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.admin.indices.validate.query.ShardValidateQueryResponse;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.admin.indices.validate.query.ValidateQueryRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.admin.indices.validate.query.ValidateQueryResponse;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.support.ActionFilters;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.support.DefaultShardOperationFailedException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.support.broadcast.BroadcastShardOperationFailedException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.support.broadcast.TransportBroadcastAction;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.ClusterState;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.block.ClusterBlockException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.routing.GroupShardsIterator;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.routing.ShardRouting;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.service.ClusterService;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.ParsingException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.Randomness;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.inject.Inject;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.lease.Releasables;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.query.ParsedQuery;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.query.QueryShardException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.DefaultSearchContext;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.SearchService;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.internal.AliasFilter;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.internal.SearchContext;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.internal.ShardSearchLocalRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.tasks.Task;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.threadpool.ThreadPool;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.transport.TransportService;

public class TransportValidateQueryAction
extends TransportBroadcastAction<ValidateQueryRequest, ValidateQueryResponse, ShardValidateQueryRequest, ShardValidateQueryResponse> {
    private final SearchService searchService;

    @Inject
    public TransportValidateQueryAction(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, SearchService searchService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(settings, "indices:admin/validate/query", threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, ValidateQueryRequest::new, ShardValidateQueryRequest::new, "search");
        this.searchService = searchService;
    }

    @Override
    protected void doExecute(Task task, ValidateQueryRequest request, ActionListener<ValidateQueryResponse> listener) {
        request.nowInMillis = System.currentTimeMillis();
        super.doExecute(task, request, listener);
    }

    @Override
    protected ShardValidateQueryRequest newShardRequest(int numShards, ShardRouting shard, ValidateQueryRequest request) {
        AliasFilter aliasFilter = this.searchService.buildAliasFilter(this.clusterService.state(), shard.getIndexName(), request.indices());
        return new ShardValidateQueryRequest(shard.shardId(), aliasFilter, request);
    }

    @Override
    protected ShardValidateQueryResponse newShardResponse() {
        return new ShardValidateQueryResponse();
    }

    @Override
    protected GroupShardsIterator shards(ClusterState clusterState, ValidateQueryRequest request, String[] concreteIndices) {
        String routing = request.allShards() ? null : Integer.toString(Randomness.get().nextInt(1000));
        Map<String, Set<String>> routingMap = this.indexNameExpressionResolver.resolveSearchRouting(clusterState, routing, request.indices());
        return this.clusterService.operationRouting().searchShards(clusterState, concreteIndices, routingMap, "_local");
    }

    @Override
    protected ClusterBlockException checkGlobalBlock(ClusterState state, ValidateQueryRequest request) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.READ);
    }

    @Override
    protected ClusterBlockException checkRequestBlock(ClusterState state, ValidateQueryRequest countRequest, String[] concreteIndices) {
        return state.blocks().indicesBlockedException(ClusterBlockLevel.READ, concreteIndices);
    }

    @Override
    protected ValidateQueryResponse newResponse(ValidateQueryRequest request, AtomicReferenceArray shardsResponses, ClusterState clusterState) {
        int successfulShards = 0;
        int failedShards = 0;
        boolean valid = true;
        ArrayList<DefaultShardOperationFailedException> shardFailures = null;
        ArrayList<QueryExplanation> queryExplanations = null;
        for (int i = 0; i < shardsResponses.length(); ++i) {
            Object shardResponse = shardsResponses.get(i);
            if (shardResponse == null) continue;
            if (shardResponse instanceof BroadcastShardOperationFailedException) {
                ++failedShards;
                if (shardFailures == null) {
                    shardFailures = new ArrayList<DefaultShardOperationFailedException>();
                }
                shardFailures.add(new DefaultShardOperationFailedException((BroadcastShardOperationFailedException)shardResponse));
                continue;
            }
            ShardValidateQueryResponse validateQueryResponse = (ShardValidateQueryResponse)shardResponse;
            boolean bl = valid = valid && validateQueryResponse.isValid();
            if (request.explain() || request.rewrite() || request.allShards()) {
                if (queryExplanations == null) {
                    queryExplanations = new ArrayList<QueryExplanation>();
                }
                queryExplanations.add(new QueryExplanation(validateQueryResponse.getIndex(), request.allShards() ? validateQueryResponse.getShardId().getId() : -1, validateQueryResponse.isValid(), validateQueryResponse.getExplanation(), validateQueryResponse.getError()));
            }
            ++successfulShards;
        }
        return new ValidateQueryResponse(valid, queryExplanations, shardsResponses.length(), successfulShards, failedShards, shardFailures);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    protected ShardValidateQueryResponse shardOperation(ShardValidateQueryRequest request) throws IOException {
        boolean valid;
        String explanation = null;
        String error = null;
        ShardSearchLocalRequest shardSearchLocalRequest = new ShardSearchLocalRequest(request.shardId(), request.types(), request.nowInMillis(), request.filteringAliases());
        DefaultSearchContext searchContext = this.searchService.createSearchContext(shardSearchLocalRequest, SearchService.NO_TIMEOUT);
        try {
            ParsedQuery parsedQuery = ((SearchContext)searchContext).getQueryShardContext().toQuery(request.query());
            ((SearchContext)searchContext).parsedQuery(parsedQuery);
            ((SearchContext)searchContext).preProcess(request.rewrite());
            valid = true;
            explanation = this.explain(searchContext, request.rewrite());
        }
        catch (ParsingException | QueryShardException e) {
            valid = false;
            error = e.getDetailedMessage();
            Releasables.close(searchContext);
        }
        catch (IOException | AssertionError e2) {
            valid = false;
            error = ((Throwable)e2).getMessage();
            {
                catch (Throwable throwable) {
                    Releasables.close(searchContext);
                    throw throwable;
                }
            }
            Releasables.close(searchContext);
        }
        Releasables.close(searchContext);
        return new ShardValidateQueryResponse(request.shardId(), valid, explanation, error);
    }

    private String explain(SearchContext context, boolean rewritten) throws IOException {
        Query query = context.query();
        if (rewritten && query instanceof MatchNoDocsQuery) {
            return context.parsedQuery().query().toString();
        }
        return query.toString();
    }
}

