/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.termvectors;

import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.Fields;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.PostingsEnum;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.Term;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.Terms;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.TermsEnum;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.CollectionStatistics;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.TermStatistics;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.termvectors.TermVectorsFilter;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.termvectors.TermVectorsRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.termvectors.TermVectorsResponse;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.Nullable;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.bytes.BytesReference;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.dfs.AggregatedDfs;

final class TermVectorsWriter {
    final List<String> fields = new ArrayList<String>();
    final List<Long> fieldOffset = new ArrayList<Long>();
    final BytesStreamOutput output = new BytesStreamOutput(1);
    private static final String HEADER = "TV";
    private static final int CURRENT_VERSION = -1;
    TermVectorsResponse response = null;
    private static final Terms EMPTY_TERMS = new Terms(){

        @Override
        public TermsEnum iterator() throws IOException {
            return TermsEnum.EMPTY;
        }

        @Override
        public long size() throws IOException {
            return 0L;
        }

        @Override
        public long getSumTotalTermFreq() throws IOException {
            return 0L;
        }

        @Override
        public long getSumDocFreq() throws IOException {
            return 0L;
        }

        @Override
        public int getDocCount() throws IOException {
            return 0;
        }

        @Override
        public boolean hasFreqs() {
            return false;
        }

        @Override
        public boolean hasOffsets() {
            return false;
        }

        @Override
        public boolean hasPositions() {
            return false;
        }

        @Override
        public boolean hasPayloads() {
            return false;
        }
    };

    TermVectorsWriter(TermVectorsResponse termVectorsResponse) throws IOException {
        this.response = termVectorsResponse;
    }

    void setFields(Fields termVectorsByField, Set<String> selectedFields, EnumSet<TermVectorsRequest.Flag> flags, Fields topLevelFields, @Nullable AggregatedDfs dfs, @Nullable TermVectorsFilter termVectorsFilter) throws IOException {
        int numFieldsWritten = 0;
        PostingsEnum docsAndPosEnum = null;
        PostingsEnum docsEnum = null;
        boolean hasScores = termVectorsFilter != null;
        for (String field : termVectorsByField) {
            boolean useDocsAndPos;
            if (selectedFields != null && !selectedFields.contains(field)) continue;
            Terms fieldTermVector = termVectorsByField.terms(field);
            Terms topLevelTerms = topLevelFields.terms(field);
            if (topLevelTerms == null) {
                topLevelTerms = EMPTY_TERMS;
            }
            TermsEnum topLevelIterator = topLevelTerms.iterator();
            boolean positions = flags.contains((Object)TermVectorsRequest.Flag.Positions) && fieldTermVector.hasPositions();
            boolean offsets = flags.contains((Object)TermVectorsRequest.Flag.Offsets) && fieldTermVector.hasOffsets();
            boolean payloads = flags.contains((Object)TermVectorsRequest.Flag.Payloads) && fieldTermVector.hasPayloads();
            long termsSize = fieldTermVector.size();
            if (hasScores) {
                termsSize = Math.min(termsSize, termVectorsFilter.size(field));
            }
            this.startField(field, termsSize, positions, offsets, payloads);
            if (flags.contains((Object)TermVectorsRequest.Flag.FieldStatistics)) {
                if (dfs != null) {
                    this.writeFieldStatistics((CollectionStatistics)dfs.fieldStatistics().get((Object)field));
                } else {
                    this.writeFieldStatistics(topLevelTerms);
                }
            }
            TermsEnum iterator = fieldTermVector.iterator();
            boolean bl = useDocsAndPos = positions || offsets || payloads;
            while (iterator.next() != null) {
                BytesRef termBytesRef = iterator.term();
                Term term = new Term(field, termBytesRef);
                if (hasScores && !termVectorsFilter.hasScoreTerm(term)) continue;
                this.startTerm(termBytesRef);
                if (flags.contains((Object)TermVectorsRequest.Flag.TermStatistics)) {
                    if (dfs != null) {
                        TermStatistics statistics = (TermStatistics)dfs.termStatistics().get((Object)term);
                        this.writeTermStatistics(statistics == null ? new TermStatistics(termBytesRef, 0L, 0L) : statistics);
                    } else {
                        boolean foundTerm = topLevelIterator.seekExact(termBytesRef);
                        if (foundTerm) {
                            this.writeTermStatistics(topLevelIterator);
                        } else {
                            this.writeTermStatistics(new TermStatistics(termBytesRef, 0L, 0L));
                        }
                    }
                }
                if (useDocsAndPos) {
                    docsAndPosEnum = this.writeTermWithDocsAndPos(iterator, docsAndPosEnum, positions, offsets, payloads);
                } else {
                    docsEnum = this.writeTermWithDocsOnly(iterator, docsEnum);
                }
                if (!hasScores) continue;
                this.writeScoreTerm(termVectorsFilter.getScoreTerm(term));
            }
            ++numFieldsWritten;
        }
        this.response.setTermVectorsField(this.output);
        this.response.setHeader(this.writeHeader(numFieldsWritten, flags.contains((Object)TermVectorsRequest.Flag.TermStatistics), flags.contains((Object)TermVectorsRequest.Flag.FieldStatistics), hasScores));
    }

    private BytesReference writeHeader(int numFieldsWritten, boolean getTermStatistics, boolean getFieldStatistics, boolean scores) throws IOException {
        BytesStreamOutput header = new BytesStreamOutput();
        header.writeString(HEADER);
        header.writeInt(-1);
        header.writeBoolean(getTermStatistics);
        header.writeBoolean(getFieldStatistics);
        header.writeBoolean(scores);
        header.writeVInt(numFieldsWritten);
        for (int i = 0; i < this.fields.size(); ++i) {
            header.writeString(this.fields.get(i));
            header.writeVLong(this.fieldOffset.get(i));
        }
        header.close();
        return header.bytes();
    }

    private PostingsEnum writeTermWithDocsOnly(TermsEnum iterator, PostingsEnum docsEnum) throws IOException {
        docsEnum = iterator.postings(docsEnum);
        int nextDoc = docsEnum.nextDoc();
        assert (nextDoc != Integer.MAX_VALUE);
        this.writeFreq(docsEnum.freq());
        nextDoc = docsEnum.nextDoc();
        assert (nextDoc == Integer.MAX_VALUE);
        return docsEnum;
    }

    private PostingsEnum writeTermWithDocsAndPos(TermsEnum iterator, PostingsEnum docsAndPosEnum, boolean positions, boolean offsets, boolean payloads) throws IOException {
        docsAndPosEnum = iterator.postings(docsAndPosEnum, 120);
        int nextDoc = docsAndPosEnum.nextDoc();
        assert (nextDoc != Integer.MAX_VALUE);
        int freq = docsAndPosEnum.freq();
        this.writeFreq(freq);
        for (int j = 0; j < freq; ++j) {
            int curPos = docsAndPosEnum.nextPosition();
            if (positions) {
                this.writePosition(curPos);
            }
            if (offsets) {
                this.writeOffsets(docsAndPosEnum.startOffset(), docsAndPosEnum.endOffset());
            }
            if (!payloads) continue;
            this.writePayload(docsAndPosEnum.getPayload());
        }
        nextDoc = docsAndPosEnum.nextDoc();
        assert (nextDoc == Integer.MAX_VALUE);
        return docsAndPosEnum;
    }

    private void writePayload(BytesRef payload) throws IOException {
        if (payload != null) {
            this.output.writeVInt(payload.length);
            this.output.writeBytes(payload.bytes, payload.offset, payload.length);
        } else {
            this.output.writeVInt(0);
        }
    }

    private void writeFreq(int termFreq) throws IOException {
        this.writePotentiallyNegativeVInt(termFreq);
    }

    private void writeOffsets(int startOffset, int endOffset) throws IOException {
        assert (startOffset >= 0);
        assert (endOffset >= 0);
        if (startOffset >= 0 && endOffset >= 0) {
            this.output.writeVInt(startOffset);
            this.output.writeVInt(endOffset);
        }
    }

    private void writePosition(int pos) throws IOException {
        assert (pos >= 0);
        if (pos >= 0) {
            this.output.writeVInt(pos);
        }
    }

    private void startField(String fieldName, long termsSize, boolean writePositions, boolean writeOffsets, boolean writePayloads) throws IOException {
        this.fields.add(fieldName);
        this.fieldOffset.add(this.output.position());
        this.output.writeVLong(termsSize);
        this.output.writeBoolean(writePositions);
        this.output.writeBoolean(writeOffsets);
        this.output.writeBoolean(writePayloads);
    }

    private void startTerm(BytesRef term) throws IOException {
        this.output.writeVInt(term.length);
        this.output.writeBytes(term.bytes, term.offset, term.length);
    }

    private void writeTermStatistics(TermsEnum topLevelIterator) throws IOException {
        int docFreq = topLevelIterator.docFreq();
        assert (docFreq >= -1);
        this.writePotentiallyNegativeVInt(docFreq);
        long ttf = topLevelIterator.totalTermFreq();
        assert (ttf >= -1L);
        this.writePotentiallyNegativeVLong(ttf);
    }

    private void writeTermStatistics(TermStatistics termStatistics) throws IOException {
        int docFreq = (int)termStatistics.docFreq();
        assert (docFreq >= -1);
        this.writePotentiallyNegativeVInt(docFreq);
        long ttf = termStatistics.totalTermFreq();
        assert (ttf >= -1L);
        this.writePotentiallyNegativeVLong(ttf);
    }

    private void writeFieldStatistics(Terms topLevelTerms) throws IOException {
        long sttf = topLevelTerms.getSumTotalTermFreq();
        assert (sttf >= -1L);
        this.writePotentiallyNegativeVLong(sttf);
        long sdf = topLevelTerms.getSumDocFreq();
        assert (sdf >= -1L);
        this.writePotentiallyNegativeVLong(sdf);
        int dc = topLevelTerms.getDocCount();
        assert (dc >= -1);
        this.writePotentiallyNegativeVInt(dc);
    }

    private void writeFieldStatistics(CollectionStatistics fieldStats) throws IOException {
        long sttf = fieldStats.sumTotalTermFreq();
        assert (sttf >= -1L);
        this.writePotentiallyNegativeVLong(sttf);
        long sdf = fieldStats.sumDocFreq();
        assert (sdf >= -1L);
        this.writePotentiallyNegativeVLong(sdf);
        int dc = (int)fieldStats.docCount();
        assert (dc >= -1);
        this.writePotentiallyNegativeVInt(dc);
    }

    private void writeScoreTerm(TermVectorsFilter.ScoreTerm scoreTerm) throws IOException {
        this.output.writeFloat(Math.max(0.0f, scoreTerm.score));
    }

    private void writePotentiallyNegativeVInt(int value) throws IOException {
        this.output.writeVInt(Math.max(0, value + 1));
    }

    private void writePotentiallyNegativeVLong(long value) throws IOException {
        this.output.writeVLong(Math.max(0L, value + 1L));
    }
}

