/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.analysis;

import java.io.IOException;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.analysis.Analyzer;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.Version;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.env.Environment;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.IndexSettings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.analysis.AnalyzerProvider;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.analysis.AnalyzerScope;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.analysis.PreBuiltAnalyzerProvider;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.indices.analysis.AnalysisModule;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.indices.analysis.PreBuiltAnalyzers;

public class PreBuiltAnalyzerProviderFactory
implements AnalysisModule.AnalysisProvider<AnalyzerProvider<?>> {
    private final PreBuiltAnalyzerProvider analyzerProvider;

    public PreBuiltAnalyzerProviderFactory(String name, AnalyzerScope scope, Analyzer analyzer) {
        this.analyzerProvider = new PreBuiltAnalyzerProvider(name, scope, analyzer);
    }

    public AnalyzerProvider<?> create(String name, Settings settings) {
        PreBuiltAnalyzers preBuiltAnalyzers;
        Version indexVersion = Version.indexCreated(settings);
        if (!Version.CURRENT.equals(indexVersion) && (preBuiltAnalyzers = PreBuiltAnalyzers.getOrDefault(name, null)) != null) {
            Analyzer analyzer = preBuiltAnalyzers.getAnalyzer(indexVersion);
            return new PreBuiltAnalyzerProvider(name, AnalyzerScope.INDICES, analyzer);
        }
        return this.analyzerProvider;
    }

    @Override
    public AnalyzerProvider<?> get(IndexSettings indexSettings, Environment environment, String name, Settings settings) throws IOException {
        return this.create(name, settings);
    }

    public Analyzer analyzer() {
        return this.analyzerProvider.get();
    }
}

