/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.mapper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.collect.CopyOnWriteHashMap;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.regex.Regex;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.mapper.FieldMapper;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.mapper.MappedFieldType;

class FieldTypeLookup
implements Iterable<MappedFieldType> {
    final CopyOnWriteHashMap<String, MappedFieldType> fullNameToFieldType;
    final CopyOnWriteHashMap<String, Set<String>> fullNameToTypes;

    FieldTypeLookup() {
        this.fullNameToFieldType = new CopyOnWriteHashMap();
        this.fullNameToTypes = new CopyOnWriteHashMap();
    }

    private FieldTypeLookup(CopyOnWriteHashMap<String, MappedFieldType> fullName, CopyOnWriteHashMap<String, Set<String>> fullNameToTypes) {
        this.fullNameToFieldType = fullName;
        this.fullNameToTypes = fullNameToTypes;
    }

    private static CopyOnWriteHashMap<String, Set<String>> addType(CopyOnWriteHashMap<String, Set<String>> map, String key, String type) {
        Set<String> types = map.get(key);
        if (types == null) {
            return map.copyAndPut(key, Collections.singleton(type));
        }
        if (types.contains(type)) {
            return map;
        }
        Set<String> newTypes = new HashSet<String>(types.size() + 1);
        newTypes.addAll(types);
        newTypes.add(type);
        assert (newTypes.size() == types.size() + 1);
        newTypes = Collections.unmodifiableSet(newTypes);
        return map.copyAndPut(key, newTypes);
    }

    public FieldTypeLookup copyAndAddAll(String type, Collection<FieldMapper> fieldMappers, boolean updateAllTypes) {
        Objects.requireNonNull(type, "type must not be null");
        if ("_default_".equals(type)) {
            throw new IllegalArgumentException("Default mappings should not be added to the lookup");
        }
        CopyOnWriteHashMap<String, MappedFieldType> fullName = this.fullNameToFieldType;
        CopyOnWriteHashMap<String, Set<String>> fullNameToTypes = this.fullNameToTypes;
        for (FieldMapper fieldMapper : fieldMappers) {
            MappedFieldType fieldType = fieldMapper.fieldType();
            MappedFieldType fullNameFieldType = fullName.get(fieldType.name());
            this.checkCompatibility(type, fieldMapper, updateAllTypes);
            if (!fieldType.equals(fullNameFieldType)) {
                fullName = fullName.copyAndPut(fieldType.name(), fieldMapper.fieldType());
            }
            fullNameToTypes = FieldTypeLookup.addType(fullNameToTypes, fieldType.name(), type);
        }
        return new FieldTypeLookup(fullName, fullNameToTypes);
    }

    private static boolean beStrict(String type, Set<String> types, boolean updateAllTypes) {
        assert (types.size() >= 1);
        if (updateAllTypes) {
            return false;
        }
        return types.size() != 1 || !types.contains(type);
    }

    private void checkCompatibility(String type, FieldMapper fieldMapper, boolean updateAllTypes) {
        MappedFieldType fieldType = this.fullNameToFieldType.get(fieldMapper.fieldType().name());
        if (fieldType != null) {
            ArrayList<String> conflicts = new ArrayList<String>();
            Set<String> types = this.fullNameToTypes.get(fieldMapper.fieldType().name());
            boolean strict = FieldTypeLookup.beStrict(type, types, updateAllTypes);
            fieldType.checkCompatibility(fieldMapper.fieldType(), conflicts, strict);
            if (!conflicts.isEmpty()) {
                throw new IllegalArgumentException("Mapper for [" + fieldMapper.fieldType().name() + "] conflicts with existing mapping in other types:\n" + ((Object)conflicts).toString());
            }
        }
    }

    public MappedFieldType get(String field) {
        return this.fullNameToFieldType.get(field);
    }

    public Set<String> getTypes(String field) {
        Set<String> types = this.fullNameToTypes.get(field);
        if (types == null) {
            types = Collections.emptySet();
        }
        return types;
    }

    public Collection<String> simpleMatchToFullName(String pattern) {
        HashSet<String> fields = new HashSet<String>();
        for (MappedFieldType fieldType : this) {
            if (!Regex.simpleMatch(pattern, fieldType.name())) continue;
            fields.add(fieldType.name());
        }
        return fields;
    }

    @Override
    public Iterator<MappedFieldType> iterator() {
        return this.fullNameToFieldType.values().iterator();
    }
}

