/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.plugins;

import java.nio.file.Path;
import java.util.Locale;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.Constants;

public class Platforms {
    private static final String PROGRAM_NAME = Constants.WINDOWS ? "controller.exe" : "controller";
    public static final String PLATFORM_NAME = Platforms.platformName(Constants.OS_NAME, Constants.OS_ARCH);

    private Platforms() {
    }

    public static Path nativeControllerPath(Path plugin) {
        return plugin.resolve("platform").resolve(PLATFORM_NAME).resolve("bin").resolve(PROGRAM_NAME);
    }

    public static String platformName(String osName, String osArch) {
        String lowerCaseOs = osName.toLowerCase(Locale.ROOT);
        String normalizedOs = lowerCaseOs.startsWith("windows") ? "windows" : (lowerCaseOs.equals("mac os x") ? "darwin" : lowerCaseOs);
        String lowerCaseArch = osArch.toLowerCase(Locale.ROOT);
        String normalizedArch = lowerCaseArch.equals("amd64") ? "x86_64" : (lowerCaseArch.equals("i386") ? "x86" : lowerCaseArch);
        return normalizedOs + "-" + normalizedArch;
    }
}

