/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.action.admin.indices;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.io.IOException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.ActionListener;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.admin.indices.settings.get.GetSettingsRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.admin.indices.settings.get.GetSettingsResponse;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.support.IndicesOptions;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client.node.NodeClient;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.Strings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.settings.IndexScopedSettings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.settings.SettingsFilter;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.BaseRestHandler;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.BytesRestResponse;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.RestController;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.RestRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.RestResponse;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.RestStatus;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.action.RestBuilderListener;

public class RestGetSettingsAction
extends BaseRestHandler {
    private final IndexScopedSettings indexScopedSettings;
    private final SettingsFilter settingsFilter;

    public RestGetSettingsAction(Settings settings, RestController controller, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter) {
        super(settings);
        this.indexScopedSettings = indexScopedSettings;
        controller.registerHandler(RestRequest.Method.GET, "/_settings/{name}", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_settings", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_settings/{name}", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_setting/{name}", this);
        this.settingsFilter = settingsFilter;
    }

    @Override
    public String getName() {
        return "get_settings_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(final RestRequest request, NodeClient client) throws IOException {
        String[] names = request.paramAsStringArrayOrEmptyIfAll("name");
        final boolean renderDefaults = request.paramAsBoolean("include_defaults", false);
        request.paramAsBoolean("flat_settings", false);
        GetSettingsRequest getSettingsRequest = new GetSettingsRequest().indices(Strings.splitStringByCommaToArray(request.param("index"))).indicesOptions(IndicesOptions.fromRequest(request, IndicesOptions.strictExpandOpen())).humanReadable(request.hasParam("human")).names(names);
        getSettingsRequest.local(request.paramAsBoolean("local", getSettingsRequest.local()));
        return channel -> client.admin().indices().getSettings(getSettingsRequest, (ActionListener<GetSettingsResponse>)new RestBuilderListener<GetSettingsResponse>(channel){

            @Override
            public RestResponse buildResponse(GetSettingsResponse getSettingsResponse, XContentBuilder builder) throws Exception {
                builder.startObject();
                for (ObjectObjectCursor<String, Settings> objectObjectCursor : getSettingsResponse.getIndexToSettings()) {
                    if (((Settings)objectObjectCursor.value).isEmpty()) continue;
                    builder.startObject((String)objectObjectCursor.key);
                    builder.startObject("settings");
                    ((Settings)objectObjectCursor.value).toXContent(builder, request);
                    builder.endObject();
                    if (renderDefaults) {
                        builder.startObject("defaults");
                        RestGetSettingsAction.this.settingsFilter.filter(RestGetSettingsAction.this.indexScopedSettings.diff((Settings)objectObjectCursor.value, RestGetSettingsAction.this.settings)).toXContent(builder, request);
                        builder.endObject();
                    }
                    builder.endObject();
                }
                builder.endObject();
                return new BytesRestResponse(RestStatus.OK, builder);
            }
        });
    }
}

