/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.snapshots;

import java.io.IOException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.ElasticsearchParseException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.ShardOperationFailedException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.Nullable;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentParser;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.shard.ShardId;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.snapshots.IndexShardSnapshotFailedException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.RestStatus;

public class SnapshotShardFailure
implements ShardOperationFailedException {
    private ShardId shardId;
    private String reason;
    @Nullable
    private String nodeId;
    private RestStatus status;

    private SnapshotShardFailure() {
    }

    public SnapshotShardFailure(@Nullable String nodeId, ShardId shardId, String reason) {
        this.nodeId = nodeId;
        this.shardId = shardId;
        this.reason = reason;
        assert (reason != null);
        this.status = RestStatus.INTERNAL_SERVER_ERROR;
    }

    @Override
    public String index() {
        return this.shardId.getIndexName();
    }

    @Override
    public int shardId() {
        return this.shardId.id();
    }

    @Override
    public String reason() {
        return this.reason;
    }

    @Override
    public RestStatus status() {
        return this.status;
    }

    @Override
    public Throwable getCause() {
        return new IndexShardSnapshotFailedException(this.shardId, this.reason);
    }

    @Nullable
    public String nodeId() {
        return this.nodeId;
    }

    public static SnapshotShardFailure readSnapshotShardFailure(StreamInput in) throws IOException {
        SnapshotShardFailure exp = new SnapshotShardFailure();
        exp.readFrom(in);
        return exp;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.nodeId = in.readOptionalString();
        this.shardId = ShardId.readShardId(in);
        this.reason = in.readString();
        this.status = RestStatus.readFrom(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.nodeId);
        this.shardId.writeTo(out);
        out.writeString(this.reason);
        RestStatus.writeTo(out, this.status);
    }

    public String toString() {
        return this.shardId + " failed, reason [" + this.reason + "]";
    }

    public static void toXContent(SnapshotShardFailure snapshotShardFailure, XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        snapshotShardFailure.toXContent(builder, params);
        builder.endObject();
    }

    public static SnapshotShardFailure fromXContent(XContentParser parser) throws IOException {
        SnapshotShardFailure snapshotShardFailure = new SnapshotShardFailure();
        XContentParser.Token token = parser.currentToken();
        String index = null;
        String index_uuid = "_na_";
        int shardId = -1;
        if (token == XContentParser.Token.START_OBJECT) {
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    String currentFieldName = parser.currentName();
                    token = parser.nextToken();
                    if (!token.isValue()) continue;
                    if ("index".equals(currentFieldName)) {
                        index = parser.text();
                        continue;
                    }
                    if ("index_uuid".equals(currentFieldName)) {
                        index_uuid = parser.text();
                        continue;
                    }
                    if ("node_id".equals(currentFieldName)) {
                        snapshotShardFailure.nodeId = parser.text();
                        continue;
                    }
                    if ("reason".equals(currentFieldName)) {
                        snapshotShardFailure.reason = parser.textOrNull();
                        continue;
                    }
                    if ("shard_id".equals(currentFieldName)) {
                        shardId = parser.intValue();
                        continue;
                    }
                    if ("status".equals(currentFieldName)) {
                        snapshotShardFailure.status = RestStatus.valueOf(parser.text());
                        continue;
                    }
                    throw new ElasticsearchParseException("unknown parameter [{}]", currentFieldName);
                }
                throw new ElasticsearchParseException("unexpected token [{}]", new Object[]{token});
            }
        } else {
            throw new ElasticsearchParseException("unexpected token [{}]", new Object[]{token});
        }
        if (index == null) {
            throw new ElasticsearchParseException("index name was not set", new Object[0]);
        }
        if (shardId == -1) {
            throw new ElasticsearchParseException("index shard was not set", new Object[0]);
        }
        snapshotShardFailure.shardId = new ShardId(index, index_uuid, shardId);
        if (snapshotShardFailure.reason == null) {
            snapshotShardFailure.reason = "";
        }
        return snapshotShardFailure;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("index", this.shardId.getIndexName());
        builder.field("index_uuid", this.shardId.getIndexName());
        builder.field("shard_id", this.shardId.id());
        builder.field("reason", this.reason);
        if (this.nodeId != null) {
            builder.field("node_id", this.nodeId);
        }
        builder.field("status", this.status.name());
        return builder;
    }
}

