/*
 * Decompiled with CFR 0.152.
 */
package com.dim.hot.parse;

import com.dim.hot.common.Logger;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;

public class PublicXmlHolder {
    public static final String KEY_RESOURCES = "resources";
    public static final String KEY_PUBLIC = "public";
    public static final String KEY_TYPE = "type";
    public static final String KEY_NAME = "name";
    public static final String KEY_ID = "id";
    private Map<String, String> typeMaxMap = new HashMap<String, String>();
    private Map<String, Map<String, String>> data = new HashMap<String, Map<String, String>>();

    public PublicXmlHolder(String filePatch) {
        try {
            File file = new File(filePatch);
            Document doc = Jsoup.parse((File)file, (String)"utf-8");
            for (Element element : doc.getAllElements()) {
                if (!KEY_PUBLIC.equals(element.tagName())) continue;
                this.putField(element.attr(KEY_TYPE), element.attr(KEY_NAME), element.attr(KEY_ID));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void putField(String type, String name, String id) {
        Map<String, String> typeMap = this.data.get(type);
        if (typeMap == null) {
            typeMap = new HashMap<String, String>();
            this.data.put(type, typeMap);
        }
        typeMap.put(name, id);
        String maxId = this.typeMaxMap.get(type);
        if (maxId == null) {
            this.typeMaxMap.put(type, id);
        } else if (maxId.hashCode() < id.hashCode()) {
            this.typeMaxMap.put(type, id);
        }
    }

    public String getMaxId(String type, String currentId) throws IllegalStateException {
        String maxId = this.typeMaxMap.get(type);
        if (maxId != null) {
            long i = Long.parseLong(maxId.substring(2), 16);
            String newId = "0x" + Long.toHexString(++i);
            if (newId.substring(0, 6).equals(currentId.substring(0, 6))) {
                this.typeMaxMap.put(type, newId);
                Logger.dim("newId " + type + "/ id =   ->  " + newId);
                return newId;
            }
            throw new IllegalStateException("Can't fund the right id" + currentId + "  ");
        }
        this.typeMaxMap.put(type, currentId);
        return currentId;
    }

    public String getFile(String type, String name) {
        Map<String, String> typeMap = this.data.get(type);
        if (type == null) {
            Logger.dim("not fund  type =" + type + " resource");
            return null;
        }
        String id = typeMap.get(name);
        if (id == null) {
            Logger.dim("not fund  type =" + type + "/" + name + " resource");
        }
        return id;
    }

    public Map<String, String> getFileMap(String type) {
        Map<String, String> typeMap = this.data.get(type);
        if (type == null) {
            return Collections.emptyMap();
        }
        return typeMap;
    }
}

