/*
 * Decompiled with CFR 0.152.
 */
package com.ele.hot.exe.comand;

import com.ele.hot.common.Logger;
import java.io.InputStream;

public abstract class Command<T, I> {
    private RunListener runListener;

    public Command() {
    }

    public Command(RunListener runListener) {
        this.runListener = runListener;
    }

    public boolean exec() {
        if (this.runListener != null) {
            this.runListener.runBefore();
        }
        boolean run = this.run();
        if (this.runListener != null) {
            this.runListener.runAfter();
        }
        return run;
    }

    public abstract boolean run();

    public static String executeCommand(String command) {
        String result = null;
        try {
            Process exec = Runtime.getRuntime().exec(command);
            InputStream errorStream = exec.getErrorStream();
            byte[] buffer = new byte[2048];
            int readBytes = 0;
            StringBuilder stringBuilder = new StringBuilder();
            while ((readBytes = errorStream.read(buffer)) > 0) {
                stringBuilder.append(new String(buffer, 0, readBytes));
            }
            result = stringBuilder.toString();
        }
        catch (Exception e) {
            Logger.dim(e.toString());
            e.printStackTrace();
        }
        return result;
    }

    public T getResult() {
        return null;
    }

    public I getError() {
        return null;
    }

    public static class RunListenerAdapter
    implements RunListener {
        @Override
        public void runBefore() {
        }

        @Override
        public void runAfter() {
        }
    }

    public static interface RunListener {
        public void runBefore();

        public void runAfter();
    }
}

