/*
 * Decompiled with CFR 0.152.
 */
package com.ele.hot.exe.comand.adb;

import com.ele.hot.DeviceResult;
import com.ele.hot.bean.PatchBean;
import com.ele.hot.common.IdeUtils;
import com.ele.hot.common.Logger;
import com.ele.hot.exe.comand.Command;
import java.io.IOException;
import org.apache.commons.io.FileUtils;

public class AdbPushCommand
extends Command<Void, String> {
    private DeviceResult deviceResult;
    private PatchBean patchBean;
    private String error = "";
    private static final String TAG = "AdbPushCommand";

    public AdbPushCommand(DeviceResult deviceResult, PatchBean patchBean) {
        this.deviceResult = deviceResult;
        this.patchBean = patchBean;
    }

    @Override
    public boolean run() {
        String command = IdeUtils.getAdbPath() + " -s " + this.deviceResult.device.getSerialNumber() + " push  " + this.patchBean.getPatchOutPutFile() + " " + this.patchBean.getPushTargetFile();
        Logger.dim(TAG, command);
        String result = AdbPushCommand.executeCommand(command);
        Logger.dim(TAG, result);
        if (result.contains("failed") || result.contains("error") || result.contains(" no ")) {
            this.error = "push failure";
            StringBuilder sb = new StringBuilder();
            sb.append("push  failure :").append(command).append("\n");
            sb.append(result);
            try {
                FileUtils.writeStringToFile(this.patchBean.getErrorFile(), sb.toString());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return false;
        }
        return true;
    }

    @Override
    public String getError() {
        return this.error;
    }
}

