/*
 * Decompiled with CFR 0.152.
 */
package com.ele.hot.exe.comand.io;

import com.ele.hot.common.Logger;
import com.ele.hot.exe.comand.Command;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;

public class DirectoryCopyCommand
extends Command<Void, Void> {
    private static final String TAG = "FileCopyCommand";
    private File srcFile;
    private File destFile;

    public DirectoryCopyCommand(File srcFile, File destFile) {
        this.srcFile = srcFile;
        this.destFile = destFile;
    }

    public DirectoryCopyCommand(File srcFile, File destFile, Command.RunListener runListener) {
        super(runListener);
        this.srcFile = srcFile;
        this.destFile = destFile;
    }

    @Override
    public boolean run() {
        try {
            FileUtils.copyDirectory(this.srcFile, this.destFile);
            Logger.dim(TAG, "copy directory " + this.srcFile + "->" + this.destFile);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

