/*
 * Decompiled with CFR 0.152.
 */
package com.ele.hot.ui;

import com.google.common.collect.Lists;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ChooseModulesDialog;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;

public final class ModuleChooserDialogHelper {
    public static final String SELECTED_MODULE_PROPERTY = ModuleChooserDialogHelper.class.getCanonicalName() + "-SELECTED_MODULE";

    private ModuleChooserDialogHelper() {
    }

    public static AndroidFacet showDialogForFacets(Project project, List<AndroidFacet> facets) {
        ArrayList modules = Lists.newArrayList();
        String previousModuleName = ModuleChooserDialogHelper.getPreviousModuleName(project);
        ArrayList previousSelectedModule = null;
        for (AndroidFacet facet : facets) {
            Module module = facet.getModule();
            modules.add(module);
            if (!module.getName().equals(previousModuleName)) continue;
            previousSelectedModule = Lists.newArrayList((Object[])new Module[]{module});
        }
        ChooseModulesDialog dialog = new ChooseModulesDialog(project, (List)modules, "Choose Module", "");
        dialog.setSingleSelectionMode();
        if (previousSelectedModule != null) {
            dialog.selectElements(previousSelectedModule);
        }
        dialog.show();
        List chosenElements = dialog.getChosenElements();
        if (chosenElements.isEmpty()) {
            return null;
        }
        Module chosenModule = (Module)chosenElements.get(0);
        ModuleChooserDialogHelper.saveModuleName(project, chosenModule.getName());
        int chosenModuleIndex = modules.indexOf(chosenModule);
        return facets.get(chosenModuleIndex);
    }

    private static void saveModuleName(Project project, String moduleName) {
        PropertiesComponent properties = PropertiesComponent.getInstance((Project)project);
        properties.setValue(SELECTED_MODULE_PROPERTY, moduleName);
    }

    private static String getPreviousModuleName(Project project) {
        PropertiesComponent properties = PropertiesComponent.getInstance((Project)project);
        return properties.getValue(SELECTED_MODULE_PROPERTY);
    }
}

