/*
 * Decompiled with CFR 0.152.
 */
package com.dim.hot.action;

import com.dim.hot.DeviceResult;
import com.dim.hot.action.BaseAction;
import com.dim.hot.bean.CommandLogHolder;
import com.dim.hot.bean.FilePropertyHolder;
import com.dim.hot.bean.PatchBean;
import com.dim.hot.exe.comand.BsdiffCommand;
import com.dim.hot.exe.comand.Command;
import com.dim.hot.exe.comand.CommandExecutor;
import com.dim.hot.exe.comand.ExecCommand;
import com.dim.hot.exe.comand.adb.AdbPushAllPatchDexCommand;
import com.dim.hot.exe.comand.io.DirectoryCopyCommand;
import com.dim.hot.ui.NotificationHelper;
import com.intellij.openapi.actionSystem.AnActionEvent;
import java.io.File;
import java.util.ArrayList;

public class BuildPatchAction
extends BaseAction {
    @Override
    void run(DeviceResult deviceResult, AnActionEvent anActionEvent) {
        this.buildSrc(deviceResult);
    }

    private void buildSrc(DeviceResult deviceResult) {
        final long current = System.currentTimeMillis();
        final PatchBean patch = PatchBean.createFromFile(deviceResult.fixApkVersionItem.path + File.separator + "basis" + File.separator + "config.json", null);
        File logFile = new File(deviceResult.fixApkVersionItem.path + File.separator + "log_" + patch.getPatchSerialNumber() + ".txt");
        String local = deviceResult.anActionEvent.getProject().getBasePath() + File.separator + "local.properties";
        FilePropertyHolder filePropertyHolder = new FilePropertyHolder(new File(local));
        CommandLogHolder logHolder = new CommandLogHolder(logFile);
        ArrayList<Command> commands = new ArrayList<Command>();
        DirectoryCopyCommand copyRFile = new DirectoryCopyCommand(logHolder, patch.getRFile(), patch.getTargetRFile(), new Command.RunListenerAdapter(){

            @Override
            public void runBefore() {
                patch.getTargetRFile().delete();
            }
        });
        ExecCommand execCommand = new ExecCommand(logHolder, "cd " + deviceResult.anActionEvent.getProject().getBaseDir().getPath() + " \n./gradlew assemble" + new File(deviceResult.fixApkVersionItem.path).getName() + "Patch -P basis=" + deviceResult.fixApkVersionItem.path + "  -P serial_number=" + patch.getPatchSerialNumber() + " --stacktrace");
        BsdiffCommand bsdiffCommand = new BsdiffCommand(filePropertyHolder, logHolder, patch);
        AdbPushAllPatchDexCommand adbPushAllPatchDexCommand = new AdbPushAllPatchDexCommand(logHolder, deviceResult, patch);
        commands.add(copyRFile);
        commands.add(execCommand);
        commands.add(bsdiffCommand);
        if (deviceResult.device != null) {
            commands.add(adbPushAllPatchDexCommand);
        }
        new CommandExecutor(logHolder).execute(deviceResult.anActionEvent.getProject(), commands, new CommandExecutor.ExecuteListener(){

            @Override
            public void success() {
                NotificationHelper.info(patch.getPatchName() + " successfully [ " + (System.currentTimeMillis() - current) + "ms ]");
            }

            @Override
            public void failure(String message) {
                NotificationHelper.error(message);
            }
        });
    }
}

