/*
 * Decompiled with CFR 0.152.
 */
package com.dim.hot.action;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.dim.hot.DeviceResult;
import com.dim.hot.action.BaseAction;
import com.dim.hot.bean.PatchBean;
import com.dim.hot.exe.comand.Command;
import com.dim.hot.exe.comand.CommandExecutor;
import com.dim.hot.exe.comand.adb.AdbPushCommand;
import com.dim.hot.ui.NotificationHelper;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import java.io.File;
import java.util.ArrayList;
import org.jetbrains.android.sdk.AndroidSdkUtils;

public class PushAction
extends BaseAction {
    private PatchBean patchBean;
    private File dexFile;

    @Override
    protected DeviceResult getDeviceResult(AnActionEvent anActionEvent) {
        AndroidDebugBridge bridge = AndroidSdkUtils.getDebugBridge((Project)anActionEvent.getProject());
        if (bridge == null) {
            NotificationHelper.error("No platform configured");
            return null;
        }
        if (bridge.isConnected() && bridge.hasInitialDeviceList()) {
            IDevice[] devices = bridge.getDevices();
            if (devices.length == 1) {
                return new DeviceResult(anActionEvent, devices[0], null, null);
            }
            if (devices.length > 1) {
                return PushAction.askUserForDevice(anActionEvent, null, null);
            }
            return new DeviceResult(anActionEvent, null, null, null);
        }
        return new DeviceResult(anActionEvent, null, null, null);
    }

    public void update(AnActionEvent e) {
        super.update(e);
        e.getPresentation().setVisible(this.runEnable(e));
    }

    @Override
    void run(DeviceResult deviceResult, AnActionEvent anActionEvent) {
        final long current = System.currentTimeMillis();
        ArrayList<Command> commands = new ArrayList<Command>();
        AdbPushCommand push = new AdbPushCommand(null, deviceResult, this.dexFile, this.patchBean);
        commands.add(push);
        new CommandExecutor(null).execute(deviceResult.anActionEvent.getProject(), commands, new CommandExecutor.ExecuteListener(){

            @Override
            public void success() {
                NotificationHelper.info(PushAction.this.patchBean.getPatchName() + " successfully [ " + (System.currentTimeMillis() - current) + "ms ]");
            }

            @Override
            public void failure(String message) {
                NotificationHelper.error(message);
            }
        });
    }

    @Override
    protected boolean runEnable(AnActionEvent anActionEvent) {
        String apkName;
        Object o = anActionEvent.getDataContext().getData("psi.File");
        if (o instanceof PsiFile && (apkName = ((PsiFile)o).getName()).endsWith(".dex")) {
            PsiDirectory parent1;
            PsiDirectory parent = ((PsiFile)o).getParent();
            this.dexFile = new File(((PsiFile)o).getVirtualFile().getPath());
            if (parent != null && (parent1 = parent.getParent()) != null) {
                File config = new File(parent1.getVirtualFile().getPath() + File.separator + "basis", "config.json");
                if (parent.getName().startsWith("patch") && parent.getName().length() > 5) {
                    this.patchBean = PatchBean.createFromFile(config.toString(), parent.getName().substring(5));
                }
                return this.patchBean != null;
            }
        }
        return false;
    }
}

