/*
 * Decompiled with CFR 0.152.
 */
package com.dim.hot.bean;

import com.dim.hot.common.Logger;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class CommandLogHolder {
    private FileWriter fileWriter;
    private OnWriteListener onWriteListener;

    public CommandLogHolder(File logFile) {
        if (!logFile.exists()) {
            logFile.getParentFile().mkdir();
            try {
                logFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            this.fileWriter = new FileWriter(logFile, true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setOnWriteListener(OnWriteListener onWriteListener) {
        this.onWriteListener = onWriteListener;
    }

    public void write(String message) {
        Logger.dim(message);
        if (this.fileWriter != null) {
            try {
                this.fileWriter.write(message + "\n");
                this.fileWriter.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.onWriteListener != null) {
            this.onWriteListener.onWrite(message);
        }
    }

    public void flush() {
        if (this.fileWriter != null) {
            try {
                this.fileWriter.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    this.fileWriter.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static interface OnWriteListener {
        public void onWrite(String var1);
    }
}

