/*
 * Decompiled with CFR 0.152.
 */
package com.dim.hot.common;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Enumeration;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class ZipTool {
    private static void zip(String srcRootDir, File file, ZipOutputStream zos) throws Exception {
        if (file == null) {
            return;
        }
        if (file.isFile()) {
            int count;
            int bufferLen = 1024;
            byte[] data = new byte[bufferLen];
            String subPath = file.getAbsolutePath();
            int index = subPath.indexOf(srcRootDir);
            if (index != -1) {
                subPath = subPath.substring(srcRootDir.length() + File.separator.length());
            }
            ZipEntry entry = new ZipEntry(subPath);
            zos.putNextEntry(entry);
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
            while ((count = bis.read(data, 0, bufferLen)) != -1) {
                zos.write(data, 0, count);
            }
            bis.close();
            zos.closeEntry();
        } else {
            File[] childFileList = file.listFiles();
            for (int n = 0; n < childFileList.length; ++n) {
                childFileList[n].getAbsolutePath().indexOf(file.getAbsolutePath());
                ZipTool.zip(srcRootDir, childFileList[n], zos);
            }
        }
    }

    public static void zip(String srcPath, String zipPath, String zipFileName) throws Exception {
        CheckedOutputStream cos = null;
        ZipOutputStream zos = null;
        try {
            int index;
            String zipFilePath;
            File zipFile;
            File srcFile = new File(srcPath);
            File zipDir = new File(zipPath);
            if (!zipDir.exists() || !zipDir.isDirectory()) {
                zipDir.mkdirs();
            }
            if ((zipFile = new File(zipFilePath = zipPath + File.separator + zipFileName)).exists()) {
                SecurityManager securityManager = new SecurityManager();
                securityManager.checkDelete(zipFilePath);
                zipFile.delete();
            }
            cos = new CheckedOutputStream(new FileOutputStream(zipFile), new CRC32());
            zos = new ZipOutputStream(cos);
            String srcRootDir = srcPath;
            if (srcFile.isFile() && (index = srcPath.lastIndexOf(File.separator)) != -1) {
                srcRootDir = srcPath.substring(0, index);
            }
            ZipTool.zip(srcRootDir, srcFile, zos);
            zos.flush();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                if (zos != null) {
                    zos.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void unzip(String zipFilePath, String unzipFilePath, boolean includeZipFileName) throws Exception {
        File unzipFileDir;
        File zipFile = new File(zipFilePath);
        if (includeZipFileName) {
            String fileName = zipFile.getName();
            fileName = fileName.substring(0, fileName.lastIndexOf("."));
            unzipFilePath = unzipFilePath + File.separator + fileName;
        }
        if (!(unzipFileDir = new File(unzipFilePath)).exists() || !unzipFileDir.isDirectory()) {
            unzipFileDir.mkdirs();
        }
        ZipEntry entry = null;
        String entryFilePath = null;
        String entryDirPath = null;
        File entryFile = null;
        File entryDir = null;
        int index = 0;
        int count = 0;
        int bufferSize = 1024;
        byte[] buffer = new byte[bufferSize];
        BufferedInputStream bis = null;
        BufferedOutputStream bos = null;
        ZipFile zip = new ZipFile(zipFile);
        Enumeration<? extends ZipEntry> entries = zip.entries();
        while (entries.hasMoreElements()) {
            entry = entries.nextElement();
            entryFilePath = unzipFilePath + File.separator + entry.getName();
            index = entryFilePath.lastIndexOf(File.separator);
            entryDirPath = index != -1 ? entryFilePath.substring(0, index) : "";
            entryDir = new File(entryDirPath);
            if (!entryDir.exists() || !entryDir.isDirectory()) {
                entryDir.mkdirs();
            }
            if ((entryFile = new File(entryFilePath)).exists()) {
                SecurityManager securityManager = new SecurityManager();
                securityManager.checkDelete(entryFilePath);
                entryFile.delete();
            }
            bos = new BufferedOutputStream(new FileOutputStream(entryFile));
            bis = new BufferedInputStream(zip.getInputStream(entry));
            while ((count = bis.read(buffer, 0, bufferSize)) != -1) {
                bos.write(buffer, 0, count);
            }
            bos.flush();
            bos.close();
        }
    }
}

