/*
 * Decompiled with CFR 0.152.
 */
package com.dim.hot.exe.comand;

import com.dim.hot.bean.CommandLogHolder;
import com.dim.hot.bean.FilePropertyHolder;
import com.dim.hot.bean.PatchBean;
import com.dim.hot.common.Logger;
import com.dim.hot.exe.comand.Command;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import org.jdesktop.swingx.util.OS;

public class BsdiffCommand
extends Command<Void, String> {
    private final FilePropertyHolder filePropertyHolder;
    private PatchBean patch;
    private String errorText;

    public BsdiffCommand(FilePropertyHolder filePropertyHolder, CommandLogHolder logHolder, PatchBean patch) {
        super(logHolder);
        this.filePropertyHolder = filePropertyHolder;
        this.patch = patch;
    }

    @Override
    public boolean run() {
        File[] files = new File(this.patch.getPatchOutPutFilePath()).getParentFile().listFiles();
        if (files == null) {
            return false;
        }
        for (File file : files) {
            if (file.isDirectory() || !file.getName().matches("classes\\d?.dex")) continue;
            String name = file.getName();
            File old = new File(this.patch.getClassFile().getAbsolutePath() + File.separator + name);
            File newP = new File(file.getAbsolutePath());
            File patchF = new File(file.getParentFile().getAbsolutePath() + File.separator + "patch" + name);
            String bsdiffPath = this.filePropertyHolder.getProperty("bsdiff");
            if (bsdiffPath == null) {
                if (OS.isMacOSX()) {
                    bsdiffPath = "/usr/local/bin/bsdiff";
                } else if (OS.isWindows()) {
                    bsdiffPath = this.superExe("where bsdiff");
                } else if (OS.isLinux()) {
                    bsdiffPath = this.superExe("which bsdiff");
                }
            }
            if (bsdiffPath == null || bsdiffPath.length() == 0) {
                this.errorText = "\u8bf7\u5b89\u88c5 bsdiff, \u5982\u679c\u5df2\u7ecf\u5b89\u88c5\u8bf7\u5728local.properties \u6307\u5b9a bsdiff \u7684\u5b89\u88c5\u4f4d\u7f6e.";
                return false;
            }
            String bsdiffCommand = bsdiffPath + " " + old.getAbsolutePath() + " " + newP.getAbsolutePath() + " " + patchF.getAbsolutePath();
            this.writeMessage(bsdiffCommand);
            String result = BsdiffCommand.executeCommand(bsdiffCommand);
            this.writeMessage(result);
            if (result.startsWith("-bash:")) {
                this.errorText = "\u8bf7\u5b89\u88c5 bsdiff, \u5982\u679c\u5df2\u7ecf\u5b89\u88c5\u8bf7\u5728local.properties \u6307\u5b9a bsdiff \u7684\u5b89\u88c5\u4f4d\u7f6e.";
                return false;
            }
            if (!result.equals("")) continue;
            file.delete();
        }
        return true;
    }

    @Override
    public String getError() {
        return this.errorText;
    }

    public String superExe(String command) {
        File wd = new File("/bin");
        System.out.println(wd);
        Process proc = null;
        try {
            proc = Runtime.getRuntime().exec("/bin/bash", null, wd);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (proc != null) {
            BufferedReader in = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            PrintWriter out = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(proc.getOutputStream())), true);
            out.println(command);
            out.println("exit");
            try {
                StringBuffer sb = new StringBuffer();
                String line = in.readLine();
                while (line != null) {
                    sb.append(line);
                    this.writeMessage(line);
                    line = in.readLine();
                }
                Logger.dim("end");
                proc.waitFor();
                in.close();
                out.close();
                proc.destroy();
                return sb.toString();
            }
            catch (Exception e) {
                Logger.dim(e.getMessage());
                e.printStackTrace();
            }
        }
        return "";
    }
}

