/*
 * Decompiled with CFR 0.152.
 */
package com.dim.hot.exe.comand;

import com.dim.hot.bean.CommandLogHolder;
import com.dim.hot.common.Logger;
import com.dim.hot.exe.comand.Command;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CommandExecutor {
    private final CommandLogHolder logHolder;

    public CommandExecutor(CommandLogHolder logHolder) {
        this.logHolder = logHolder;
    }

    public void execute(Project project, final List<Command> list, final ExecuteListener executeListener) {
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, "buildPatch"){

            public void run(final ProgressIndicator progressIndicator) {
                if (CommandExecutor.this.logHolder != null) {
                    CommandExecutor.this.logHolder.setOnWriteListener(new CommandLogHolder.OnWriteListener(){

                        @Override
                        public void onWrite(String message) {
                            Matcher matcher = Pattern.compile(":\\w+:\\w+").matcher(message);
                            if (matcher.find()) {
                                progressIndicator.setText(matcher.group());
                            }
                        }
                    });
                }
                try {
                    for (int i = 0; i < list.size(); ++i) {
                        Command command = (Command)list.get(i);
                        Logger.dim(command.toString());
                        if (!command.exec()) {
                            progressIndicator.setFraction(1.0);
                            progressIndicator.setText("failure");
                            executeListener.failure(command.getError() != null ? command.getError() + "" : "failure");
                            return;
                        }
                        if (i + 1 == list.size()) {
                            progressIndicator.setFraction(1.0);
                            progressIndicator.setText("finished");
                            continue;
                        }
                        progressIndicator.setIndeterminate(true);
                    }
                    executeListener.success();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    executeListener.failure("failure ");
                    progressIndicator.setFraction(1.0);
                    progressIndicator.setText("failure");
                }
            }
        });
    }

    public static interface ExecuteListener {
        public void success();

        public void failure(String var1);
    }
}

