/*
 * Decompiled with CFR 0.152.
 */
package com.dim.hot.exe.comand.adb;

import com.dim.hot.DeviceResult;
import com.dim.hot.bean.CommandLogHolder;
import com.dim.hot.bean.PatchBean;
import com.dim.hot.common.IdeUtils;
import com.dim.hot.exe.comand.Command;
import java.io.File;

public class AdbPushCommand
extends Command<Void, String> {
    private DeviceResult deviceResult;
    private File file;
    private PatchBean patchBean;
    private String error = "";
    private static final String TAG = "AdbPushCommand";

    public AdbPushCommand(DeviceResult deviceResult, PatchBean patchBean) {
        this.deviceResult = deviceResult;
        this.patchBean = patchBean;
    }

    public AdbPushCommand(CommandLogHolder logHolder, DeviceResult deviceResult, File file, PatchBean patchBean) {
        super(logHolder);
        this.deviceResult = deviceResult;
        this.file = file;
        this.patchBean = patchBean;
    }

    @Override
    public boolean run() {
        String command = IdeUtils.getAdbPath() + " -s " + this.deviceResult.device.getSerialNumber() + " push  " + this.file.getAbsolutePath() + " " + this.patchBean.getPushTargetFile();
        this.writeMessage(":push: push -> " + this.patchBean.getPushTargetFile());
        this.writeMessage(command);
        String result = AdbPushCommand.executeCommand(command);
        this.writeMessage(result);
        if (result.contains("failed") || result.contains("error") || result.contains(" no ")) {
            this.error = "push failure";
            StringBuilder sb = new StringBuilder();
            sb.append("push  failure :").append(command).append("\n");
            sb.append(result);
            return false;
        }
        return true;
    }

    @Override
    public String getError() {
        return this.error;
    }
}

