/*
 * Decompiled with CFR 0.152.
 */
package com.dim.hot.ui;

import com.android.ddmlib.IDevice;
import com.dim.hot.ui.DeviceChooserListener;
import com.dim.hot.ui.MyDeviceChooser;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joor.Reflect;

public class DeviceChooserDialog
extends DialogWrapper {
    private final Project myProject;
    private final MyDeviceChooser myDeviceChooser;
    private JPanel myPanel;
    private JPanel myDeviceChooserWrapper;
    @NonNls
    private static final String SELECTED_SERIALS_PROPERTY = DeviceChooserDialog.class.getCanonicalName() + "-SELECTED_DEVICES";

    public DeviceChooserDialog(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/dim/hot/ui/DeviceChooserDialog", "<init>"));
        }
        super(facet.getModule().getProject(), true);
        Object[] objectArray = new Object[]{};
        this.$$$setupUI$$$();
        this.setTitle(AndroidBundle.message((String)"choose.device.dialog.title", (Object[])objectArray));
        this.myProject = facet.getModule().getProject();
        PropertiesComponent properties = PropertiesComponent.getInstance((Project)this.myProject);
        this.getOKAction().setEnabled(false);
        this.myDeviceChooser = new MyDeviceChooser(false, this.getOKAction(), facet, ((AndroidFacetConfiguration)facet.getConfiguration()).getAndroidTarget(), null);
        Disposer.register((Disposable)this.myDisposable, (Disposable)this.myDeviceChooser);
        this.myDeviceChooser.addListener(new DeviceChooserListener(){

            @Override
            public void selectedDevicesChanged() {
                DeviceChooserDialog.this.updateOkButton();
            }
        });
        this.myDeviceChooserWrapper.add(this.myDeviceChooser.getPanel());
        String[] selectedSerials = this.getSelectedSerialsFromPreferences(properties);
        this.myDeviceChooser.init(selectedSerials);
        this.init();
        this.updateEnabled();
    }

    @Nullable
    private String[] getSelectedSerialsFromPreferences(PropertiesComponent properties) {
        String serialsStr = properties.getValue(SELECTED_SERIALS_PROPERTY);
        String[] selectedSerials = serialsStr != null ? serialsStr.split(" ") : null;
        return selectedSerials;
    }

    private void persistSelectedSerialsToPreferences() {
        PropertiesComponent properties = PropertiesComponent.getInstance((Project)this.myProject);
        properties.setValue(SELECTED_SERIALS_PROPERTY, DeviceChooserDialog.toString(this.myDeviceChooser.getSelectedDevices()));
    }

    private void updateOkButton() {
        this.getOKAction().setEnabled(this.getSelectedDevices().length > 0);
    }

    private void updateEnabled() {
        this.updateOkButton();
    }

    public JComponent getPreferredFocusedComponent() {
        try {
            return this.myDeviceChooser.getPreferredFocusComponent();
        }
        catch (NoSuchMethodError e) {
            return (JComponent)Reflect.on(this.myDeviceChooser).call("getDeviceTable").get();
        }
    }

    protected void doOKAction() {
        this.myDeviceChooser.finish();
        this.persistSelectedSerialsToPreferences();
        super.doOKAction();
    }

    protected String getDimensionServiceKey() {
        return ((Object)((Object)this)).getClass().getCanonicalName();
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    @NotNull
    public IDevice[] getSelectedDevices() {
        IDevice[] iDeviceArray = this.myDeviceChooser.getSelectedDevices();
        if (iDeviceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/dim/hot/ui/DeviceChooserDialog", "getSelectedDevices"));
        }
        return iDeviceArray;
    }

    @NotNull
    public static String toString(@NotNull IDevice[] devices) {
        if (devices == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "devices", "com/dim/hot/ui/DeviceChooserDialog", "toString"));
        }
        StringBuilder builder = new StringBuilder();
        int n = devices.length;
        for (int i = 0; i < n; ++i) {
            builder.append(devices[i].getSerialNumber());
            if (i >= n - 1) continue;
            builder.append(' ');
        }
        String string = builder.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/dim/hot/ui/DeviceChooserDialog", "toString"));
        }
        return string;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myDeviceChooserWrapper = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

