/*
 * Decompiled with CFR 0.152.
 */
package com.ele.hot.action;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.sdk.IdeSdks;
import com.ele.hot.DeviceResult;
import com.ele.hot.FixApkVersionBean;
import com.ele.hot.ui.DeviceChooserDialog;
import com.ele.hot.ui.FixAPKVersion2Dialog;
import com.ele.hot.ui.NotificationHelper;
import com.google.common.collect.Lists;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.android.util.AndroidUtils;

public abstract class BaseAction
extends AnAction {
    public void actionPerformed(AnActionEvent anActionEvent) {
        DeviceResult deviceResult = this.getDevice(anActionEvent);
        if (deviceResult == null) {
            return;
        }
        if (deviceResult.device != null) {
            if (IdeSdks.getAndroidSdkPath() == null) {
                NotificationHelper.error("android sdk is null ");
            } else if (this.runEnable(anActionEvent)) {
                this.run(deviceResult, anActionEvent);
            }
        }
    }

    protected boolean runEnable(AnActionEvent anActionEvent) {
        return true;
    }

    protected String getAndroidFacetName(AnActionEvent anActionEvent) {
        return null;
    }

    abstract void run(DeviceResult var1, AnActionEvent var2);

    private DeviceResult getDevice(AnActionEvent anActionEvent) {
        List<FixApkVersionBean> applicationFacets = BaseAction.getApplicationFacets(anActionEvent.getProject());
        if (!applicationFacets.isEmpty()) {
            FixAPKVersion2Dialog fixAPKVersion2Dialog = new FixAPKVersion2Dialog(anActionEvent.getProject(), applicationFacets);
            fixAPKVersion2Dialog.show();
            if (fixAPKVersion2Dialog.getExitCode() != 0 || fixAPKVersion2Dialog.getFixApkVersionItem() == null) {
                return null;
            }
            FixApkVersionBean.FixApkVersionItem fixApkVersionItem = fixAPKVersion2Dialog.getFixApkVersionItem();
            AndroidDebugBridge bridge = AndroidSdkUtils.getDebugBridge((Project)anActionEvent.getProject());
            if (bridge == null) {
                NotificationHelper.error("No platform configured");
                return null;
            }
            String packageName = fixApkVersionItem.androidFacet.getAndroidModuleInfo().getPackage();
            if (bridge.isConnected() && bridge.hasInitialDeviceList()) {
                IDevice[] devices = bridge.getDevices();
                if (devices.length == 1) {
                    return new DeviceResult(anActionEvent, devices[0], fixApkVersionItem, packageName);
                }
                if (devices.length > 1) {
                    return BaseAction.askUserForDevice(anActionEvent, fixApkVersionItem, packageName);
                }
                return new DeviceResult(anActionEvent, null, fixApkVersionItem, null);
            }
        }
        return new DeviceResult(anActionEvent, null, null, null);
    }

    private static List<FixApkVersionBean> getApplicationFacets(Project project) {
        ArrayList fixApkVersionBeanList = Lists.newArrayList();
        for (AndroidFacet facet : AndroidUtils.getApplicationFacets((Project)project)) {
            if (BaseAction.isTestProject(facet)) continue;
            FixApkVersionBean fixApkVersionBean = new FixApkVersionBean(facet);
            String moduleDirPath = AndroidRootUtil.getMainContentRoot((AndroidFacet)facet).getPath();
            File file = new File(moduleDirPath + File.separator + "elePatch");
            if (file.exists()) {
                File[] versions;
                for (File version : versions = file.listFiles()) {
                    File[] buildTypes;
                    for (File buildType : buildTypes = version.listFiles()) {
                        if (!BaseAction.validSrcFile(buildType)) continue;
                        fixApkVersionBean.addVersion(BaseAction.getVersion(buildType), buildType.getAbsolutePath());
                    }
                }
            }
            if (!fixApkVersionBean.hasFixVersion()) continue;
            fixApkVersionBeanList.add(fixApkVersionBean);
        }
        return fixApkVersionBeanList;
    }

    private static boolean validSrcFile(File item) {
        if (!BaseAction.validFileExists(new File(item.getAbsoluteFile() + File.separator + "basis"))) {
            return false;
        }
        if (!BaseAction.validFileExists(new File(item.getAbsoluteFile() + File.separator + "basis" + File.separator + "r"))) {
            return false;
        }
        if (!BaseAction.validFileExists(new File(item.getAbsoluteFile() + File.separator + "basis" + File.separator + "hash.txt"))) {
            return false;
        }
        return BaseAction.validFileExists(new File(item.getAbsoluteFile() + File.separator + "basis" + File.separator + "mapping.txt"));
    }

    private static String getVersion(File item) {
        return item.getParentFile().getName() + "_" + item.getName();
    }

    private static boolean validResFile(File item) {
        if (!BaseAction.validFileExists(new File(item.getAbsoluteFile() + File.separator + "manifests"))) {
            return false;
        }
        if (!BaseAction.validFileExists(new File(item.getAbsoluteFile() + File.separator + "public" + File.separator + "public.xml"))) {
            return false;
        }
        if (!BaseAction.validFileExists(new File(item.getAbsoluteFile() + File.separator + "res"))) {
            return false;
        }
        return BaseAction.validFileExists(new File(item.getAbsoluteFile() + File.separator + "config.json"));
    }

    private static boolean validFileExists(File file) {
        if (file.isDirectory()) {
            return file.exists() && file.listFiles() != null && file.length() != 0L;
        }
        return file.exists();
    }

    private static boolean isTestProject(AndroidFacet facet) {
        return facet.getManifest() != null && facet.getManifest().getInstrumentations() != null && !facet.getManifest().getInstrumentations().isEmpty();
    }

    private static DeviceResult askUserForDevice(AnActionEvent anActionEvent, FixApkVersionBean.FixApkVersionItem fixApkVersionItem, String packageName) {
        DeviceChooserDialog chooser = new DeviceChooserDialog(fixApkVersionItem.androidFacet);
        chooser.show();
        if (chooser.getExitCode() != 0) {
            return null;
        }
        IDevice[] selectedDevices = chooser.getSelectedDevices();
        if (selectedDevices.length == 0) {
            return null;
        }
        return new DeviceResult(anActionEvent, selectedDevices[0], fixApkVersionItem, packageName);
    }
}

