/*
 * Decompiled with CFR 0.152.
 */
package com.ele.hot.action;

import com.ele.hot.DeviceResult;
import com.ele.hot.action.BaseAction;
import com.ele.hot.bean.PatchBean;
import com.ele.hot.exe.comand.Command;
import com.ele.hot.exe.comand.CommandExecuter;
import com.ele.hot.exe.comand.ExecCommand;
import com.ele.hot.exe.comand.aapt.AaptPackageCommand;
import com.ele.hot.exe.comand.adb.AdbPushCommand;
import com.ele.hot.exe.comand.io.DirectoryCopyCommand;
import com.ele.hot.exe.comand.io.FileCopyCommand;
import com.ele.hot.exe.comand.parse.SeparaterIDsFromPublicXmlCommand;
import com.ele.hot.parse.PublicXmlHolder;
import com.ele.hot.ui.NotificationHelper;
import com.intellij.openapi.actionSystem.AnActionEvent;
import java.io.File;
import java.util.ArrayList;

public class BuildPatchAction
extends BaseAction {
    @Override
    void run(DeviceResult deviceResult, AnActionEvent anActionEvent) {
        this.buildSrc(deviceResult);
    }

    private void buildSrc(DeviceResult deviceResult) {
        final long current = System.currentTimeMillis();
        final PatchBean patch = new PatchBean(deviceResult.fixApkVersionItem.path + File.separator + "basis" + File.separator + "config.json");
        ArrayList<Command> commands = new ArrayList<Command>();
        DirectoryCopyCommand copyRFile = new DirectoryCopyCommand(patch.getRFile(), patch.getTargetRFile(), new Command.RunListenerAdapter(){

            @Override
            public void runBefore() {
                patch.getTargetRFile().delete();
            }
        });
        ExecCommand execCommand = new ExecCommand("cd " + deviceResult.anActionEvent.getProject().getBaseDir().getPath() + " \n./gradlew assemble" + new File(deviceResult.fixApkVersionItem.path).getName() + "Patch -P basis=" + deviceResult.fixApkVersionItem.path + "  -P serial_number=" + patch.getPatchSerialNumber());
        AdbPushCommand push = new AdbPushCommand(deviceResult, patch);
        commands.add(copyRFile);
        commands.add(execCommand);
        commands.add(push);
        new CommandExecuter().execute(commands, new CommandExecuter.ExecuteListener(){

            @Override
            public void success() {
                NotificationHelper.info(patch.getPatchName() + " successfully [ " + (System.currentTimeMillis() - current) + "ms ]");
            }

            @Override
            public void failure(String message) {
                NotificationHelper.error(message);
            }
        });
    }

    private void buildRes(DeviceResult deviceResult) {
        final long current = System.currentTimeMillis();
        final PatchBean patch = new PatchBean(deviceResult.fixApkVersionItem.path + File.separator + "config.json");
        ArrayList<Command> commands = new ArrayList<Command>();
        File fullUpdateIdsFile = patch.getFullUpdateIdsFile();
        File fullUpdateIPublicFile = patch.getFullUpdateIPublicFile();
        if (fullUpdateIdsFile.exists() && fullUpdateIPublicFile.exists()) {
            FileCopyCommand copyIds = new FileCopyCommand(fullUpdateIdsFile, patch.getValuesIdsFile());
            FileCopyCommand copyPublic = new FileCopyCommand(fullUpdateIPublicFile, patch.getValuesPublicFile());
            AaptPackageCommand reBuild = new AaptPackageCommand(patch, null, null);
            AdbPushCommand push = new AdbPushCommand(deviceResult, patch);
            commands.add(copyIds);
            commands.add(copyPublic);
            commands.add(reBuild);
            commands.add(push);
        } else {
            SeparaterIDsFromPublicXmlCommand separaterIDsFromPublicXml = new SeparaterIDsFromPublicXmlCommand(new PublicXmlHolder(patch.getPublicXmlFilePath()), patch.getValuesIdsFile());
            FileCopyCommand copyPublicToBuildFile = new FileCopyCommand(new File(patch.getPublicXmlFilePath()), patch.getValuesPublicFile());
            AaptPackageCommand build = new AaptPackageCommand(patch, null, null);
            FileCopyCommand copyIdsToFullFile = new FileCopyCommand(patch.getValuesIdsFile(), fullUpdateIdsFile);
            FileCopyCommand copyPublicToFullFile = new FileCopyCommand(patch.getValuesPublicFile(), fullUpdateIPublicFile);
            AdbPushCommand push = new AdbPushCommand(deviceResult, patch);
            commands.add(separaterIDsFromPublicXml);
            commands.add(copyPublicToBuildFile);
            commands.add(build);
            commands.add(copyIdsToFullFile);
            commands.add(copyPublicToFullFile);
            commands.add(push);
        }
        new CommandExecuter().execute(commands, new CommandExecuter.ExecuteListener(){

            @Override
            public void success() {
                NotificationHelper.info(patch.getPatchName() + " successfully [ " + (System.currentTimeMillis() - current) + "ms ]");
            }

            @Override
            public void failure(String message) {
                NotificationHelper.error(message);
            }
        });
    }
}

