/*
 * Decompiled with CFR 0.152.
 */
package com.ele.hot.bean;

import com.ele.hot.bean.Config;
import com.ele.hot.common.IdeUtils;
import com.ele.hot.common.IoUtils;
import com.ele.hot.common.Logger;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.FileUtils;

public class PatchBean {
    public static final String ROOT_NAME = "elePatch";
    public static final String PATCH_FILE_NAME = "patch";
    public static final String MAPPING_FILE_NAME = "mapping.txt";
    public static final String HASH_FILE_NAME = "hash.txt";
    public static final String BASIS_FILE_NAME = "basis";
    private Config config;
    private String flavorBuildType;
    private String version;
    private String appModuleFile;
    private String patchFile;
    private String patchSerialNumber;
    private String outPutFile;
    private String androidJarPatch;
    private String pushTargetFilePath;
    private List<String> list = new ArrayList<String>();

    public PatchBean(String filePath) {
        File file = new File(filePath);
        this.flavorBuildType = file.getParentFile().getParentFile().getName();
        this.patchFile = file.getParentFile().getParent();
        this.appModuleFile = file.getParentFile().getParentFile().getParentFile().getParentFile().getParent();
        this.outPutFile = file.getParentFile().getParent();
        try {
            String contentConfig = FileUtils.readFileToString(file);
            this.config = Config.getConfig(contentConfig);
            this.androidJarPatch = IdeUtils.getAndroidSdkPath() + File.separator + "platforms/" + this.config.compileSdkVersion + "/android.jar";
            for (String item : this.config.resList) {
                if (!new File(item).exists()) continue;
                this.list.add(item);
            }
            this.list.add(this.patchFile + File.separator + "res" + File.separator + this.flavorBuildType);
            this.pushTargetFilePath = this.config.pushTargetFilePath;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Logger.dim(this.toString());
        this.mkdirs(new File(this.patchFile));
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getBuildToolsVersion() {
        return this.config.buildToolsVersion;
    }

    public String getAppModuleFile() {
        return this.appModuleFile;
    }

    public void setAppModuleFile(String appModuleFile) {
        this.appModuleFile = appModuleFile;
    }

    public String getPatchFile() {
        return this.patchFile;
    }

    public void setPatchFile(String patchFile) {
        this.patchFile = patchFile;
    }

    public String getPublicXmlFilePath() {
        File file = new File(this.getPatchFile() + File.separator + "public" + File.separator + "public.xml");
        IoUtils.mkdir(file);
        return file.getAbsolutePath();
    }

    public File getManifestFile() {
        File file = new File(this.getPatchFile() + File.separator + "manifests" + File.separator + "AndroidManifest.xml");
        IoUtils.mkdir(file);
        return file;
    }

    private void mkdirs(File f) {
        if (!f.getParentFile().exists()) {
            f.getParentFile().mkdirs();
        }
    }

    public File getCopyTargetFile(File originFile) {
        File targetFile = new File(this.getPatchFile() + File.separator + "res" + File.separator + originFile.getName());
        IoUtils.mkdir(targetFile);
        return targetFile;
    }

    public String getPatchOutPutFile() {
        Logger.dim(this.toString());
        String patchOutputFile = this.outPutFile + File.separator + PATCH_FILE_NAME + this.getPatchSerialNumber() + File.separator + "patch.apk";
        IoUtils.mkdir(patchOutputFile);
        return patchOutputFile;
    }

    public String getPatchSerialNumber() {
        if (this.patchSerialNumber == null) {
            this.patchSerialNumber = new SimpleDateFormat("-yyyyMMdd-HHmm").format(new Date());
        }
        return this.patchSerialNumber;
    }

    public String getPatchName() {
        return PATCH_FILE_NAME + this.getPatchSerialNumber();
    }

    public String getOutPutTempPublicFile() {
        String patchOutputFile = this.outPutFile + "temp" + File.separator + "public" + this.getPatchSerialNumber() + ".xml";
        IoUtils.mkdir(patchOutputFile);
        return patchOutputFile;
    }

    public String getAndroidJarFile() {
        return this.androidJarPatch;
    }

    public List<String> getModifyRes() {
        return this.list;
    }

    public String getPushTargetFile() {
        return this.pushTargetFilePath;
    }

    public String getResValuesFilePath() {
        return this.getPatchFile() + File.separator + "res" + File.separator + this.flavorBuildType + File.separator + "values" + File.separator;
    }

    public File getErrorFile() {
        String logFile = this.outPutFile + File.separator + "log" + File.separator + PATCH_FILE_NAME + this.getPatchSerialNumber() + ".txt";
        IoUtils.mkdir(logFile);
        return new File(logFile);
    }

    public String getFullUpdateFilePath() {
        String fullFilePath = this.outPutFile + File.separator + BASIS_FILE_NAME + File.separator + "full" + File.separator;
        IoUtils.mkdir(fullFilePath);
        return fullFilePath;
    }

    public File getFullUpdateIdsFile() {
        return new File(this.getFullUpdateFilePath() + "ids.xml");
    }

    public File getFullUpdateIPublicFile() {
        return new File(this.getFullUpdateFilePath() + "public.xml");
    }

    public File getValuesIdsFile() {
        return new File(this.getResValuesIdsFilePath());
    }

    public String getRFilePath() {
        return this.outPutFile + File.separator + BASIS_FILE_NAME + File.separator + "r";
    }

    public File getRFile() {
        File file = new File(this.getRFilePath());
        IoUtils.mkdir(file);
        return file;
    }

    public File getTargetRFile() {
        return new File(this.appModuleFile + "/build/generated/source/r/" + this.config.flavor + File.separator + this.config.buildType);
    }

    public File getValuesPublicFile() {
        return new File(this.getResValuesPublicFilePath());
    }

    public String getResValuesIdsFilePath() {
        return this.getPatchFile() + File.separator + "res" + File.separator + this.flavorBuildType + File.separator + "values" + File.separator + "ids.xml";
    }

    public String getResValuesPublicFilePath() {
        return this.getPatchFile() + File.separator + "res" + File.separator + this.flavorBuildType + File.separator + "values" + File.separator + "public.xml";
    }

    public String toString() {
        return "PatchBean{config=" + this.config + ", flavorBuildType='" + this.flavorBuildType + '\'' + ", version='" + this.version + '\'' + ", appModuleFile='" + this.appModuleFile + '\'' + ", patchFile='" + this.patchFile + '\'' + ", patchSerialNumber='" + this.patchSerialNumber + '\'' + ", outPutFile='" + this.outPutFile + '\'' + ", androidJarPatch='" + this.androidJarPatch + '\'' + ", pushTargetFilePath='" + this.pushTargetFilePath + '\'' + ", list=" + this.list + '}';
    }
}

