/*
 * Decompiled with CFR 0.152.
 */
package com.ele.hot.exe;

import com.android.tools.idea.sdk.IdeSdks;
import com.ele.hot.DeviceResult;
import com.ele.hot.bean.PatchBean;
import com.ele.hot.exe.Executer;
import com.ele.hot.exe.comand.Command;
import com.ele.hot.exe.comand.CommandExecuter;
import com.ele.hot.exe.comand.aapt.AaptPackageCommand;
import com.ele.hot.exe.comand.adb.AdbPushCommand;
import com.ele.hot.exe.comand.io.FileCopyCommand;
import com.ele.hot.exe.comand.parse.SeparaterIDsFromPublicXmlCommand;
import com.ele.hot.parse.PublicXmlHolder;
import com.ele.hot.ui.NotificationHelper;
import java.io.File;
import java.util.ArrayList;

public class FullUpdateExecuter
implements Executer<DeviceResult> {
    @Override
    public void exec(DeviceResult deviceResult) {
        if (deviceResult == null) {
            return;
        }
        if (deviceResult.device == null) {
            NotificationHelper.error(" no device ");
            return;
        }
        if (IdeSdks.getAndroidSdkPath() == null) {
            NotificationHelper.error("android sdk is null ");
            return;
        }
        final long current = System.currentTimeMillis();
        final PatchBean patch = null;
        ArrayList<Command> commands = new ArrayList<Command>();
        File fullUpdateIdsFile = patch.getFullUpdateIdsFile();
        File fullUpdateIPublicFile = patch.getFullUpdateIPublicFile();
        if (fullUpdateIdsFile.exists() && fullUpdateIPublicFile.exists()) {
            FileCopyCommand copyIds = new FileCopyCommand(fullUpdateIdsFile, patch.getValuesIdsFile());
            FileCopyCommand copyPublic = new FileCopyCommand(fullUpdateIdsFile, patch.getValuesPublicFile());
            AaptPackageCommand reBuild = new AaptPackageCommand(patch, null, null);
            AdbPushCommand push = new AdbPushCommand(deviceResult, patch);
            commands.add(copyIds);
            commands.add(copyPublic);
            commands.add(reBuild);
            commands.add(push);
        } else {
            SeparaterIDsFromPublicXmlCommand separaterIDsFromPublicXml = new SeparaterIDsFromPublicXmlCommand(new PublicXmlHolder(patch.getPublicXmlFilePath()), patch.getValuesIdsFile());
            FileCopyCommand copyPublicToBuildFile = new FileCopyCommand(new File(patch.getPublicXmlFilePath()), patch.getValuesPublicFile());
            AaptPackageCommand build = new AaptPackageCommand(patch, null, null);
            FileCopyCommand copyIdsToFullFile = new FileCopyCommand(patch.getValuesIdsFile(), fullUpdateIdsFile);
            FileCopyCommand copyPublicToFullFile = new FileCopyCommand(patch.getValuesPublicFile(), fullUpdateIPublicFile);
            AdbPushCommand push = new AdbPushCommand(deviceResult, patch);
            commands.add(separaterIDsFromPublicXml);
            commands.add(copyPublicToBuildFile);
            commands.add(build);
            commands.add(copyIdsToFullFile);
            commands.add(copyPublicToFullFile);
            commands.add(push);
        }
        new CommandExecuter().execute(commands, new CommandExecuter.ExecuteListener(){

            @Override
            public void success() {
                NotificationHelper.info(patch.getPatchName() + " successfully  time consuming " + (System.currentTimeMillis() - current) + "ms");
            }

            @Override
            public void failure(String message) {
                NotificationHelper.error(message);
            }
        });
    }
}

