/*
 * Decompiled with CFR 0.152.
 */
package com.ele.hot.exe.comand.aapt;

import com.ele.hot.bean.PatchBean;
import com.ele.hot.common.IdeUtils;
import com.ele.hot.common.Logger;
import com.ele.hot.exe.comand.Command;
import java.io.IOException;
import org.apache.commons.io.FileUtils;

public class AaptPackageCommand
extends Command<Void, String> {
    private PatchBean patchBean;
    private String publicXmlFilePath;
    private String rFile;
    private String error = "";
    private static final String TAG = "AaptPackageCommand";

    public AaptPackageCommand(PatchBean patchBean, String publicXmlFilePath, String rFile) {
        this.patchBean = patchBean;
        this.publicXmlFilePath = publicXmlFilePath;
        this.rFile = rFile;
    }

    @Override
    public boolean run() {
        String command = IdeUtils.getAaptPath(this.patchBean.getBuildToolsVersion()) + " package -f --auto-add-overlay  -M " + this.patchBean.getManifestFile() + " -F " + this.patchBean.getPatchOutPutFile() + " -I " + this.patchBean.getAndroidJarFile();
        for (String s : this.patchBean.getModifyRes()) {
            command = command + " -S " + s;
        }
        if (this.publicXmlFilePath != null && this.publicXmlFilePath.length() != 0) {
            command = command + " -P " + this.publicXmlFilePath;
        }
        if (this.rFile != null && this.rFile.length() != 0) {
            command = command + "  -m  -J  " + this.rFile;
        }
        Logger.dim(TAG, command);
        String result = AaptPackageCommand.executeCommand(command);
        Logger.dim(TAG, result);
        if (result.contains("ERROR") || result.contains("error")) {
            this.error = "aapt failure ";
            StringBuilder sb = new StringBuilder();
            sb.append("aapt  command :").append(command).append("\n");
            sb.append(result);
            try {
                FileUtils.writeStringToFile(this.patchBean.getErrorFile(), sb.toString());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return false;
        }
        return true;
    }

    @Override
    public String getError() {
        return this.error;
    }
}

