/*
 * Decompiled with CFR 0.152.
 */
package com.ele.hot.parse;

import com.ele.hot.common.Logger;
import com.ele.hot.parse.IdsFileHolder;
import com.ele.hot.parse.PublicXmlHolder;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Element;

public class PublicFileOperator {
    private PublicXmlHolder publicXmlHolder;
    private String filePatch;
    private String targetFile;
    private boolean allUpdate;
    private Element rootElement;
    private IdsFileHolder idsFileHolder = new IdsFileHolder();

    public PublicFileOperator(String filePatch, PublicXmlHolder publicXmlHolder, String targetFile, boolean allUpdate) {
        File file;
        File idsFile;
        this.filePatch = filePatch;
        this.targetFile = targetFile;
        this.allUpdate = allUpdate;
        this.publicXmlHolder = publicXmlHolder;
        File publicFile = new File(targetFile + File.separator + "public.xml");
        if (publicFile.exists()) {
            publicFile.delete();
        }
        if ((idsFile = new File(targetFile + File.separator + "ids.xml")).exists()) {
            idsFile.delete();
        }
        if (!(file = new File(this.filePatch)).exists()) {
            Logger.dim("not fund file " + filePatch);
        }
        try {
            this.rootElement = (Element)Jsoup.parse((File)file, (String)"utf-8").getElementsByTag("resources").get(0);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void resetId() throws IllegalStateException {
        for (Element element : this.rootElement.getAllElements()) {
            if (!"public".equals(element.tagName())) continue;
            this.resetIdInner(element, element.attr("type"), element.attr("name"), element.attr("id"));
        }
        this.resetFileDoc();
    }

    private void resetIdInner(Element element, String type, String name, String id) throws IllegalStateException {
        String rightId = this.publicXmlHolder.getFile(type, name);
        if (rightId == null) {
            if (this.allUpdate) {
                element.remove();
                Logger.dim("remove  " + type + "/" + name + " id = " + id + "    ");
                return;
            }
        } else if (!rightId.equals(id)) {
            Logger.dim(id);
            Logger.dim("modify " + type + "/" + name + " id = " + id + "  ->  " + rightId);
            element.attr("id", rightId);
        }
        if ("id".equals(type)) {
            this.idsFileHolder.addIdName(name);
        }
    }

    private void resetFileDoc() {
        try {
            File file = new File(this.targetFile + File.separator + "public.xml");
            File idsFile = new File(this.targetFile + File.separator + "ids.xml");
            FileUtils.writeStringToFile(file, this.rootElement.toString());
            this.idsFileHolder.save(idsFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

